import bpy
import signal
import time
import os.path
import numpy as np
import shutil

"""
blender helper functions
"""


def reset_layers():
    """
    resetting render layers  and visible layers
    """
    render_layers = bpy.context.scene.render.layers
    num_layers = len(render_layers["RenderLayer"].layers[:])
    for layer in range(1, num_layers): # 0 has some extra role 
        # decactivate render layers
        render_layers["RenderLayer"].layers[layer]  = False


def save_files(outdir, fname):          
    """
    workaround: for some reason blender can't save outputs directly under a certain filename.
     -> the follwing takes the created file and copies it to the desired folder with more informative filename
    """
    p, blendname = os.path.split(bpy.data.filepath)
    blendbase = blendname.split(".")[0]
    outpath = bpy.data.scenes["Scene"].render.filepath +'results/'+ blendbase + ".Scene.00002.png"
    shutil.copy(outpath, bpy.data.scenes["Scene"].render.filepath + fname)
    script_name = os.path.basename(__file__)


def generate_fname(sensdist, objdist, imagename):
    """
    generates filename from active_layers list
    """
    fname = "obj%smm_sensor%sum.png" %(objdist/10, sensdist*100) # converting to real world units
    # folder name  
    spp = bpy.context.scene.luxrender_halt.haltspp
    resolution = bpy.context.scene.render.resolution_x # film is quadratic
    filepath = bpy.data.filepath
    p, blendname = os.path.split(filepath) 
    folder_name = "%s_%s_spp_%s_resolution%s" %(blendname.split(".")[0], imagename.split(".")[0], spp,  resolution)
    return [folder_name, fname]


def render(sensdist, dist, imagename):
    """
    renders image sensor at dist
    """
    # path to save renders to 
    folder, fname  = generate_fname(sensdist, dist, imagename)
    outdir = 'results/' + folder +"/"
    if not os.path.exists(outdir):
        print("creating new folder")
        os.makedirs(outdir)
        os.makedirs(outdir+"results/")
    print( "saving to directory: %s" %outdir)

    bpy.data.scenes["Scene"].render.filepath = outdir 

    # rendering scene
    reset_layers()
    render_layers = bpy.context.scene.render.layers
    # rendering only 1st layer
    layer = 0
    bpy.context.scene.layers[layer] = True
    render_layers["RenderLayer"].layers[layer] = True

    bpy.ops.render.render( write_still=True )
    save_files(outdir, fname)
