import bpy
import signal
import time
import os.path
import numpy as np
import shutil
import sys
sys.path.insert(1, "../")
from set_blender_params import *

scene = bpy.data.scenes["Scene"]
bpy.data.scenes["Scene"].render.image_settings.file_format = 'PNG'
bpy.context.scene.luxrender_engine.export_type='EXT'
bpy.context.scene.luxrender_engine.binary_name = 'luxconsole'
bpy.context.scene.luxrender_engine.threads = 8
bpy.context.scene.render.use_stamp = False
bpy.context.scene.luxrender_engine.threads_auto = False


bpy.context.scene.luxrender_halt.haltspp = 20000
bpy.data.objects["Camera"].data.luxrender_camera.luxrender_film.luxrender_tonemapping.type = 'autolinear'

# in blender simulation: 1m = 100um
objdistances = [-90, -110, -130, -150, -170, -190, -210, -230, -250, -270, -290, -310]
sensor_dists = [6.86, 6.95, 7.00, 7.10, 7.20] # Land's focal lenght based layer distances TopL2, BottomL2, TopL1, middleL1 BottomL1
imgpath = "../../../input_images/"
filnames  ["Goatpeaks%s"%i for i in range(1,9) ]
images = [imgpath + f for f in filenames ]

# determining name of object to be moved
plane_name = "image_plane"
object_name = "object_plane"


resolution = 117 # number of receptor based on closet receptor spacing in L1
bpy.data.cameras['Camera'].ortho_scale = 2.00 # realistic film size

bpy.context.scene.render.resolution_x = resolution
bpy.context.scene.render.resolution_y = resolution
bpy.data.cameras["Camera"].luxrender_camera.luxrender_film.write_png_16bit = True

# dimensions used for object to be seen through spider eye model  
#bpy.data.objects[object_name].dimensions = [400.,400.,0.] # for Goatpeaks dataset
bpy.data.objects[object_name].dimensions = [100.,100.,0.] # for the other datasets
bpy.context.scene.objects.active = bpy.data.objects[object_name]
bpy.ops.object.transform_apply(location=False, rotation=False, scale=True) #scales input images, important for luxrender


for imenum, img in enumerate(images):
    bpy.data.textures["pysq"].luxrender_texture.luxrender_tex_imagemap.filename=img
    for dist in objdistances:
        bpy.data.objects[object_name].location = (0, dist, 0)
        for sd in sensor_dists:
            bpy.data.objects[plane_name].location = (0, sd, 0)
            render(sd, dist, filenames[imenum])
        



